'************************************************************************
'*   File Name      :  2329_rs.bas     Version: 1.0                 
'*                                                                  
'*   entwickelt von :  C.Speck         am 03.12.1996                
'*   geaendert von  :  M.Westermann    am 26.03.1997                
'*   geaendert von  :  T. Meder V2.0   am 02.08.2002                
'*                                                                  
'*   Sprache        :  QBASIC 4.5       Betriebssystem: MS-DOS 6.22 
'*                                                                  
'*   Beschreibung   :  Programmierbeispiel fr 2329-RS232           
'*                                                                  
'*   Anmerkung      :                                               
'*                                                                  
'*   Copyright by burster przisionsmetechnik, Gernsbach 07224-6450
'************************************************************************
  ' Deklaration der verwendeten Funktionen
  DECLARE FUNCTION CmdSenden (cmd$)       ' Befehl Senden
  DECLARE SUB CmdEmpfangen (antwort$)     ' Anwort vom Gert empfangen
  DECLARE FUNCTION AbfrageSOC ()  	  'Status Operation Condition Register abfragen
  DIM antwort$(100)
  DIM befehl$(100)

  OPEN "COM1:9600,N,8,1" FOR RANDOM AS #3   ' RS232 INITIALISIEREN
  CLS                                       ' BILDSCHIRM LSCHEN
  PRINT "DEMOPROGRAMM "
  PRINT "burster Resistomat Typ 2329       "
  PRINT "Steuerung ber RS232 Schnittstelle COM1 9600 Baud "
  PRINT "bertragungsprotokoll: ANSI X3.28 A3"
  PRINT
  PRINT "Die Messung wird gestartet. Abbruch mit der Leertaste"
  PRINT

  befehl$ = "abort"             'Gert stoppen falls die Messung luft
  IF (CmdSenden(befehl$) = 0) THEN
	 SYSTEM
  END IF

  befehl$ = "init:cont 0"       'Gert auf Einzelmessung schalten
  IF (CmdSenden(befehl$) = 0) THEN
    SYSTEM
  END IF
  i = 0                         'Zhler zurcksetzen
  DO WHILE (INKEY$ = "")        'Mewerte abfragen bis die Leertaste gedrckt wird
    befehl$ = "in"              'Eine Messung starten
    IF (CmdSenden(befehl$) = 0) THEN
	SYSTEM
    END IF
    'In der nchsten Schleife wird gewartet bis im Operation-Status-Register
    'das Bit fr einen verfgbaren Mewert gesetzt ist
    done% = 0
    DO WHILE (done% <> 1)
	done% = AbfrageSOC      'Status Operation Condition Register abholen
	IF (done% = -1) THEN    'im Fehlerfalll abbrechen
	  SYSTEM
	END IF
    LOOP
  
    befehl$ = "fe?"             'Mewert abholen
    IF (CmdSenden(befehl$) = 0) THEN
	SYSTEM
    END IF
   
    CALL CmdEmpfangen(antwort$) ' Mewert abholen
    LOCATE 15, 3
    PRINT i, "Widerstandswert: ", antwort$     'Mewert anzeigen
    i = i + 1
  LOOP
END

FUNCTION AbfrageSOC
'************************************************************************
' Status Operation Condition Register abfragen
'************************************************************************
    DIM befehl$(100)
    DIM stri$(100)
    REM   Sonderzeichen werden definiert
    STX$ = CHR$(2)
    ETX$ = CHR$(3)
    EOT$ = CHR$(4)
    ENQ$ = CHR$(5)
    ACK$ = CHR$(6)
    NAK$ = CHR$(21)
    LF$ = CHR$(10)

    befehl$ = "s:o:c?"      'Status Operation Condition Register abfragen
    IF (CmdSenden(befehl$) = 0) THEN
	SYSTEM
    END IF
    CALL CmdEmpfangen(antwort$) 'Status Operation Condition Register abholen
    stat = VAL(antwort$)        'in Integer wandeln
    stat = stat AND 256        'Meende Bit8 ausmaskieren
    IF stat <> 256 THEN        'Wenn nicht Meende
	AbfrageSOC = 0         'Weiter warten
    ELSE
	AbfrageSOC = 1         'Mewert liegt vor
    END IF
END FUNCTION

SUB CmdEmpfangen (antwort$)
'************************************************************************
' Antwort vom 2329 Empfangen
'************************************************************************
    DIM stri$(100)
    DIM ant$(100)
    REM   Sonderzeichen werden definiert
    STX$ = CHR$(2)
    ETX$ = CHR$(3)
    EOT$ = CHR$(4)
    ACK$ = CHR$(6)
    NAK$ = CHR$(21)
    LF$ = CHR$(10)

    PRINT #3, EOT$                'Gert auf Master schalten
StartEmpfang:
    ant$ = ""                     'Antwortstring lschen
    stri$ = ""                    'Mewertstring lschen
    ant$ = INPUT$(1, #3)
    WHILE (ant$ <> ETX$) AND (ant$ <> EOT$) 'Solange kein ETX und EOT empfangen
	IF ant$ >= CHR$(32) THEN  ' Wenn keine Sonderzeichen
	    stri$ = stri$ + ant$  'Status String bilden
	END IF
	ant$ = INPUT$(1, #3)      'Zeichen von RS232 einlesen
    WEND
    IF (ant$ = EOT$) THEN         'Wenn EOT empfangen
	EXIT SUB                  'Sub beenden
    ELSE
	antwort$ = stri$          'Antwort speichern
	PRINT #3, ACK$            'Quittieren
	GOTO StartEmpfang         'Nochmals einlesen bis EOT kommt
    END IF
END SUB

FUNCTION CmdSenden (cmd$)
'************************************************************************
' Kommando zum 2329 senden
'************************************************************************
    DIM ant$(100)
    DIM msg$(100)
    REM   Sonderzeichen werden definiert
    STX$ = CHR$(2)
    ETX$ = CHR$(3)
    EOT$ = CHR$(4)
    ACK$ = CHR$(6)
    NAK$ = CHR$(21)
    LF$ = CHR$(10)

    msg$ = STX$ + cmd$ + LF$ + ETX$  'Befehl zusammensetzen
    PRINT #3, msg$                   'Befehl senden
    'Auf Quittierung warten
    ant$ = " "                      'Antwortstring lschen
    ant$ = INPUT$(1, #3)            'Antwort einlesen
    IF (ant$ <> ACK$) THEN          'Wenn nicht ACK
	PRINT "Gert antwortet mit NAK   "       'Fehlermeldung anzeigen
	CmdSenden = 0               ' Fehler beim Senden
    ELSE
	CmdSenden = 1               ' Alles OK beim Sende
    END IF                          'Ende von If Anweisung
END FUNCTION

